#include <Wire.h>
#include "flprogUtilites.h"
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <EEPROM.h>
LiquidCrystal_I2C _lcd1(0x27, 16, 2);
int _dispTempLength1=0;
boolean _isNeedClearDisp1;
int R_shunt_48176999_1;
float Voltage_48176999_1;
float Current_48176999_1;
float V_Shunt_48176999_1;
bool MAX_Current_48176999_1;
unsigned long old_time_48176999_1;
const int _menuParametrsArray[]  PROGMEM =  {1, 8, 3, 0, 0, 0, 5, 8, 2, 1, 3, 0, 2, 8, 2, 0, 0, 0, 4, 7, 2, 1, 2, 0, 3, 8, 1, 0, 0, 0, 3, 1, 1, 0, 1, 0, 4, 8, 4, 0, 0, 0, 6, 9, 1, 0, 4, 0, 5, 4, 1, 0, 0, 0, 2, 1, 1, 4, 5, 0};
int _menuValueArray_int[1];
const int _menuConstantValuesArray_int[]  PROGMEM =  {1, 10};
float _menuValueArray_float[4];
const float _menuConstantValuesArray_float[]  PROGMEM =  {1, 0.1, 24, 12.5, 15, 59, 11.8, 13, 0};
const char _flprogMenuNameString1[] PROGMEM = "Tdes HOUR";
const char _flprogMenuNameString2[] PROGMEM = "Umin";
const char _flprogMenuNameString3[] PROGMEM = "Umax";
const char _flprogMenuNameString4[] PROGMEM = "Tdes min";
const char _flprogMenuNameString5[] PROGMEM = "CH/DIS";
const char* const _flprogMenuStringsArray[] PROGMEM = { _flprogMenuNameString1,  _flprogMenuNameString2,  _flprogMenuNameString3,  _flprogMenuNameString4,  _flprogMenuNameString5};
struct _menuItemStricture 
{
     int startInArrayIndex;
}
;
struct _menuMainStricture 
{
    int startIndex;
    int stopIndex;
    bool isSwitchMenuAroundRing;
    _menuItemStricture  currentItem;
}
;
_menuItemStricture _MenuItems[5];
_menuMainStricture _MainMenus[1];
bool _gtv1;
bool _gtv2;
bool _gtv3;
bool _gtv4;
bool _gtv5;
bool _gtv6;
bool _bounseInputD6S = 0;
bool _bounseInputD6O = 0;
unsigned long _bounseInputD6P = 0UL;
bool _count9I = 0;
int _count9_Value = 0;
bool _Terminal_225282125;
String _MenuBlock_158695770_MNO;
String _MenuBlock_158695770_VNO;
bool _MenuBlock_158695770_OEIS = 0;
bool _MenuBlock_158695770_OMUIS = 0;
bool _MenuBlock_158695770_OMDIS = 0;
bool _MenuBlock_158695770_OVUIS = 0;
bool _MenuBlock_158695770_OVDIS = 0;
bool _Terminal_154538624;
int _disp12oldLength = 0;
bool _gen1I = 0;
bool _gen1O = 0;
unsigned long _gen1P = 0UL;
String _swi6;
bool _gen5I = 0;
bool _gen5O = 0;
unsigned long _gen5P = 0UL;
bool _count4I = 0;
int _count4_Value = 0;
bool _count4MaxLO = 0;
bool _Terminal_104140634;
bool _tim1I = 0;
bool _tim1O = 0;
unsigned long _tim1P = 0UL;
bool _count2I = 0;
int _count2_Value = 0;
bool _swi5;
bool _swi1;
int _disp2oldLength = 0;
int _disp10oldLength = 0;
bool _gen2I = 0;
bool _gen2O = 0;
unsigned long _gen2P = 0UL;
bool _swi4;
bool _count7I = 0;
int _count7_Value = 0;
bool _gen3I = 0;
bool _gen3O = 0;
unsigned long _gen3P = 0UL;
bool _bounseInputD5S = 0;
bool _bounseInputD5O = 0;
unsigned long _bounseInputD5P = 0UL;
bool _count6I = 0;
int _count6_Value = 0;
bool _count6MaxLO = 0;
bool _tim2I = 0;
bool _tim2O = 0;
unsigned long _tim2P = 0UL;
bool _trgrt2 = 0;
bool _trgrt2I = 0;
int _disp3oldLength = 0;
bool _bounseInputD3S = 0;
bool _bounseInputD3O = 0;
unsigned long _bounseInputD3P = 0UL;
int _disp7oldLength = 0;
bool _gen8I = 0;
bool _gen8O = 0;
unsigned long _gen8P = 0UL;
bool _SEEPR2OSN = 0;
bool _bounseInputD7S = 0;
bool _bounseInputD7O = 0;
unsigned long _bounseInputD7P = 0UL;
bool _Terminal_42744769;
bool _swi9;
bool _gen4I = 0;
bool _gen4O = 0;
unsigned long _gen4P = 0UL;
bool _count3I = 0;
int _count3_Value = 0;
bool _count3MaxLO = 0;
bool _trgr1 = 0;
int _disp8oldLength = 0;
int _disp6oldLength = 0;
bool _swi3;
bool _swi8;
bool _Terminal_165493977;
bool _gen7I = 0;
bool _gen7O = 0;
unsigned long _gen7P = 0UL;
int _disp4oldLength = 0;
bool _count5I = 0;
int _count5_Value = 0;
int _disp9oldLength = 0;
bool _trgr2 = 0;
bool _swi7;
bool _count8I = 0;
int _count8_Value = 0;
bool _count8MaxLO = 0;
bool _bounseInputD4S = 0;
bool _bounseInputD4O = 0;
unsigned long _bounseInputD4P = 0UL;
bool _bounseInputD2S = 0;
bool _bounseInputD2O = 0;
unsigned long _bounseInputD2P = 0UL;
bool _gen9I = 0;
bool _gen9O = 0;
unsigned long _gen9P = 0UL;
bool _Terminal_205090452;
bool _count1I = 0;
int _count1_Value = 0;
bool _count1MaxLO = 0;
bool _Terminal_94219908;
int _disp1oldLength = 0;
String _swi2;
int _disp11oldLength = 0;
bool _trgt2 = 0;
bool _trgt2I = 0;
int _disp5oldLength = 0;
bool _gen6I = 0;
bool _gen6O = 0;
unsigned long _gen6P = 0UL;
bool _SEEPR1OSN = 0;
bool _trgt3 = 0;
bool _trgt3I = 0;
bool _tempVariable_bool;
int _tempVariable_int;
void setup()
{
    pinMode(7, INPUT_PULLUP);
    pinMode(6, INPUT_PULLUP);
    pinMode(5, INPUT_PULLUP);
    pinMode(4, INPUT_PULLUP);
    pinMode(3, INPUT_PULLUP);
    pinMode(2, INPUT_PULLUP);
    pinMode(13, OUTPUT);
    digitalWrite(13, 0);
    pinMode(12, OUTPUT);
    digitalWrite(12, 0);
    pinMode(1, OUTPUT);
    digitalWrite(1, 0);
    pinMode(8, OUTPUT);
    digitalWrite(8, 0);
    Wire.begin();
    delay(10);
    if(((readByteFromEEPROM(0, 0, 0x0))) != 253) 
    {
        (updateByteToEEPROM(0, 0, 0x0, (253)));
        (updateFloatToEEPROM(1, 0, 0x0, (1)));
        (updateFloatToEEPROM(5, 0, 0x0, (11.8)));
        (updateFloatToEEPROM(9, 0, 0x0, (13)));
        (updateFloatToEEPROM(13, 0, 0x0, (1)));
        (updateIntegerToEEPROM(17, 0, 0x0, (0)));
        (updateFloatToEEPROM(23, 0, 0x0, (0)));
    }
    _lcd1.init();
    _lcd1.backlight();
    _bounseInputD7O =    digitalRead(7);
    _bounseInputD5O =    digitalRead(5);
    _bounseInputD3O =    digitalRead(3);
    _bounseInputD6O =    digitalRead(6);
    _bounseInputD2O =    digitalRead(2);
    _bounseInputD4O =    digitalRead(4);
    Wire.begin();
    	delay(200);
    Wire.beginTransmission(64);
    Wire.write(0x00);
    Wire.write(0x39);
    Wire.write(0xE7);
    Wire.endTransmission();
    _MenuItems[0].startInArrayIndex = 0;
    _MenuItems[1].startInArrayIndex = 12;
    _MenuItems[2].startInArrayIndex = 24;
    _MenuItems[3].startInArrayIndex = 36;
    _MenuItems[4].startInArrayIndex = 48;
    _MainMenus[0].startIndex = 1;
    _MainMenus[0].isSwitchMenuAroundRing = 1;
    _MainMenus[0].stopIndex = 5;
    _MainMenus[0].currentItem = _MenuItems[0];
    _menuValueArray_float[0] = (readFloatFromEEPROM(1, 0, 0x0));
    _menuValueArray_float[1] = (readFloatFromEEPROM(5, 0, 0x0));
    _menuValueArray_float[2] = (readFloatFromEEPROM(9, 0, 0x0));
    _menuValueArray_float[3] = (readFloatFromEEPROM(13, 0, 0x0));
    _menuValueArray_int[0] = (readIntegerFromEEPROM(17, 0, 0x0));
}
void loop()
{
    if (_isNeedClearDisp1) 
    {
        _lcd1.clear();
        _isNeedClearDisp1= 0;
    }
    bool  _bounceInputTmpD5 =  (digitalRead (5));
    if (_bounseInputD5S)
    {
        if (millis() >= (_bounseInputD5P + 40))
        {
            _bounseInputD5O= _bounceInputTmpD5;
            _bounseInputD5S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD5 != _bounseInputD5O)
        {
            _bounseInputD5S=1;
            _bounseInputD5P = millis();
        }
    }
    bool  _bounceInputTmpD3 =  (digitalRead (3));
    if (_bounseInputD3S)
    {
        if (millis() >= (_bounseInputD3P + 40))
        {
            _bounseInputD3O= _bounceInputTmpD3;
            _bounseInputD3S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD3 != _bounseInputD3O)
        {
            _bounseInputD3S=1;
            _bounseInputD3P = millis();
        }
    }
    bool  _bounceInputTmpD6 =  (digitalRead (6));
    if (_bounseInputD6S)
    {
        if (millis() >= (_bounseInputD6P + 40))
        {
            _bounseInputD6O= _bounceInputTmpD6;
            _bounseInputD6S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD6 != _bounseInputD6O)
        {
            _bounseInputD6S=1;
            _bounseInputD6P = millis();
        }
    }
    bool  _bounceInputTmpD4 =  (digitalRead (4));
    if (_bounseInputD4S)
    {
        if (millis() >= (_bounseInputD4P + 40))
        {
            _bounseInputD4O= _bounceInputTmpD4;
            _bounseInputD4S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD4 != _bounseInputD4O)
        {
            _bounseInputD4S=1;
            _bounseInputD4P = millis();
        }
    }
    bool  _bounceInputTmpD2 =  (digitalRead (2));
    if (_bounseInputD2S)
    {
        if (millis() >= (_bounseInputD2P + 40))
        {
            _bounseInputD2O= _bounceInputTmpD2;
            _bounseInputD2S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD2 != _bounseInputD2O)
        {
            _bounseInputD2S=1;
            _bounseInputD2P = millis();
        }
    }
    bool  _bounceInputTmpD7 =  (digitalRead (7));
    if (_bounseInputD7S)
    {
        if (millis() >= (_bounseInputD7P + 40))
        {
            _bounseInputD7O= _bounceInputTmpD7;
            _bounseInputD7S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD7 != _bounseInputD7O)
        {
            _bounseInputD7S=1;
            _bounseInputD7P = millis();
        }
    }
    //Плата:1
    R_shunt_48176999_1 = 100;
    if (2000 < (millis() - old_time_48176999_1)) 
    {
        get_Parametr__48176999_1();
        old_time_48176999_1 = millis();
    }
    bool  _tmp2 = ((!(_bounseInputD2O)) && (_Terminal_42744769));
    if (_tmp2)  
    {
         if (! _trgt2I) _trgt2 = ! _trgt2;
    }
    _trgt2I = _tmp2;
    if (((_trgt2) && (_gtv4))) 
    {
         if (! _gen6I) 
        {
            _gen6I = 1;
            _gen6O = 1;
            _gen6P = millis();
        }
    }
     else 
    {
        _gen6I = 0 ;
        _gen6O= 0;
    }
    if (_gen6I) 
    {
          if (flprog::isTimer (_gen6P , 2000)) 
        {
             _gen6P = millis();
            _gen6O = ! _gen6O;
        }
    }
    if (!(_gen6O))
    {
        if (! _count2I) 
        {
            _count2I = 1;
            _count2_Value = _count2_Value + 1;
        }
    }
     else 
    {
        _count2I = 0;
    }
    bool  _tmp3 = ((!(_bounseInputD2O)) || (_gtv3));
    if (_tmp3)  
    {
         if (! _trgt3I) _trgt3 = ! _trgt3;
    }
    _trgt3I = _tmp3;
    digitalWrite(1, _trgt3);
    _gtv4 = _trgt3;
    if (((_trgt3) && (_Terminal_42744769))) 
    {
         if (! _gen7I) 
        {
            _gen7I = 1;
            _gen7O = 1;
            _gen7P = millis();
        }
    }
     else 
    {
        _gen7I = 0 ;
        _gen7O= 0;
    }
    if (_gen7I) 
    {
          if (flprog::isTimer (_gen7P , 1000)) 
        {
             _gen7P = millis();
            _gen7O = ! _gen7O;
        }
    }
    if (_gtv2)
    {
        _count3_Value = 0;
    }
     else 
    {
        if (_gen7O)
        {
            if (! _count3I) 
            {
                _count3I = 1;
                _count3_Value = _count3_Value + 1;
            }
        }
         else 
        {
            _count3I = 0;
        }
    }
    _count3MaxLO = _count3_Value >= 60;
    if (0)
    {
        _count4_Value = 0;
    }
     else 
    {
        if (_count3MaxLO)
        {
            if (! _count4I) 
            {
                _count4I = 1;
                if(_count4_Value < 48) 
                {
                    _count4_Value = _count4_Value + 1;
                }
            }
        }
         else 
        {
            _count4I = 0;
        }
    }
    _count4MaxLO = _count4_Value >= 48;
    _gtv3 = ((((_menuValueArray_float[0])) == (_count4_Value)) && (((_menuValueArray_float[3])) == (_count3_Value)));
    _gtv2 = _count3MaxLO;
    if (_Terminal_42744769) 
    {
        _dispTempLength1 = (((((String(_count2_Value, DEC))) + (String("  ")) + ((String(_count4_Value, DEC))) + (String(":")) + ((String(_count3_Value, DEC)))))).length();
        if (_disp2oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp2oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 1);
        _lcd1.print(((((String(_count2_Value, DEC))) + (String("  ")) + ((String(_count4_Value, DEC))) + (String(":")) + ((String(_count3_Value, DEC))))));
    }
     else 
    {
        if (_disp2oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp2oldLength = 0;
        }
    }
    if ((Voltage_48176999_1) >= ((_menuValueArray_float[2]))) 
    {
        if (! _gen3I)
        {
            _gen3I = 1;
            _gen3O = 1;
            _gen3P = millis();
        }
    }
     else 
    {
        _gen3I = 0 ;
        _gen3O= 0;
    }
     if (_gen3I &&  _gen3O)   _gen3O = !(flprog::isTimer(_gen3P , 500));
    if(_gen3O) _trgr1 = 0;
    if((((((Voltage_48176999_1) < ((_menuValueArray_float[2]))) && (((((!(_bounseInputD2O)) && (_Terminal_104140634))) || (((!(_bounseInputD2O)) && (_Terminal_154538624))))))) || (_gen1O))) _trgr1 = 1;
    if (_trgr1) 
    {
        if (! _gen5I) 
        {
            _gen5I = 1;
            _gen5O = 1;
            _gen5P =  millis();
        }
    }
     else 
    {
        _gen5I = 0 ;
        _gen5O= 0;
    }
     if (_gen5I) 
    {
         if (_gen5O) 
        {
             if (flprog::isTimer(_gen5P , 200)) 
            {
                 _gen5P = millis();
                _gen5O = 0;
            }
        }
         else  
        {
             if (flprog::isTimer(_gen5P , 800)) 
            {
                  _gen5P = millis();
                _gen5O = 1;
            }
        }
    }
    if(_Terminal_94219908)
    {
        _swi3=_trgr1;
    }
    else
    {
        _swi3=0;
    }
    if(_Terminal_42744769)
    {
        _swi7=!(_gen6O);
    }
    else
    {
        _swi7=_swi3;
    }
    if(_Terminal_104140634)
    {
        _swi1=_gen5O;
    }
    else
    {
        _swi1=_swi7;
    }
    if(_Terminal_154538624)
    {
        _swi4=_trgr1;
    }
    else
    {
        _swi4=_swi1;
    }
    if(_Terminal_94219908)
    {
        _swi9=((0) || (!(_trgr1)));
    }
    else
    {
        _swi9=0;
    }
    if (((_trgt2) && (_gtv4))) 
    {
         if (! _gen4I) 
        {
            _gen4I = 1;
            _gen4O = 1;
            _gen4P = millis();
        }
    }
     else 
    {
        _gen4I = 0 ;
        _gen4O= 0;
    }
    if (_gen4I) 
    {
          if (flprog::isTimer (_gen4P , 2000)) 
        {
             _gen4P = millis();
            _gen4O = ! _gen4O;
        }
    }
    if(_Terminal_42744769)
    {
        _swi8=_gen4O;
    }
    else
    {
        _swi8=_swi9;
    }
    if(_Terminal_154538624)
    {
        _swi5=0;
    }
    else
    {
        _swi5=_swi8;
    }
    if(_trgr2) 
    {
        _tim1O = 1;
        _tim1I = 1;
    }
     else 
    {
         if(_tim1I) 
        {
            _tim1I = 0;
            _tim1P = millis();
        }
         else 
        {
             if (_tim1O) 
            {
                if (flprog::isTimer(_tim1P, 4000)) _tim1O = 0;
            }
        }
    }
    digitalWrite(12, ((((_swi5) && (((analogRead (7))) >= (600)) && (_gtv4) && (_Terminal_205090452))) || (_tim2O) || (_tim1O)));
    if (((_swi4) && (((analogRead (7))) >= (600)) && (_gtv4) && ((((analogRead (2)))/(2.048)) <= (60.00)))) 
    {
         if (! _gen2I) 
        {
            _gen2I = 1;
            _gen2O = 1;
            _gen2P = millis();
        }
    }
     else 
    {
        _gen2I = 0 ;
        _gen2O= 0;
    }
    if (_gen2I) 
    {
          if (flprog::isTimer (_gen2P , 1000)) 
        {
             _gen2P = millis();
            _gen2O = ! _gen2O;
        }
    }
    if(_gen2O)
    {
        _swi2=String("");
    }
    else
    {
        _swi2=String("PULS");
    }
    if (_Terminal_104140634) 
    {
        _dispTempLength1 = ((((String("U=")) + ((_floatToStringWitRaz(Voltage_48176999_1,1))) + (String("V ")) + (_swi2)))).length();
        if (_disp7oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp7oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("U=")) + ((_floatToStringWitRaz(Voltage_48176999_1,1))) + (String("V ")) + (_swi2))));
    }
     else 
    {
        if (_disp7oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp7oldLength = 0;
        }
    }
    if (_Terminal_42744769) 
    {
        _dispTempLength1 = ((((String("DESULFAT I=")) + ((_floatToStringWitRaz(Current_48176999_1,1))) + (String("A"))))).length();
        if (_disp8oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp8oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("DESULFAT I=")) + ((_floatToStringWitRaz(Current_48176999_1,1))) + (String("A")))));
    }
     else 
    {
        if (_disp8oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp8oldLength = 0;
        }
    }
    if(((analogRead (7))) >= (600))
    {
        _swi6=((String("Ub=")) + ((_floatToStringWitRaz(Voltage_48176999_1,1))) + (String("V ")) + (String("I=")) + ((_floatToStringWitRaz(Current_48176999_1,1))) + (String("A")));
    }
    else
    {
        _swi6=String("POLARITY");
    }
    if (_Terminal_154538624) 
    {
        _dispTempLength1 = ((_swi6)).length();
        if (_disp9oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp9oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((_swi6));
    }
     else 
    {
        if (_disp9oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp9oldLength = 0;
        }
    }
    if (_Terminal_154538624) 
    {
        _dispTempLength1 = ((((String("T= ")) + ((_floatToStringWitRaz(((analogRead (2)))/(2.048),0))) + (String("C"))))).length();
        if (_disp6oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp6oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 1);
        _lcd1.print((((String("T= ")) + ((_floatToStringWitRaz(((analogRead (2)))/(2.048),0))) + (String("C")))));
    }
     else 
    {
        if (_disp6oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp6oldLength = 0;
        }
    }
    digitalWrite(13, ((_swi4) && (((analogRead (7))) >= (600)) && (_gtv4) && ((((analogRead (2)))/(2.048)) <= (60.00))));
    digitalWrite(8, _Terminal_205090452);
    //Плата:2
    if (!(0)) 
    {
         if (_trgrt2I) 
        {
             _trgrt2 = 0;
        }
         else 
        {
            _trgrt2 = 1;
            _trgrt2I = 1;
        }
    }
     else 
    {
        _trgrt2 = 0;
        _trgrt2I = 0;
    }
    ;
    if (((_gtv1) || (_trgrt2)))
    {
        _count1_Value = 0;
    }
     else 
    {
        if (!(_bounseInputD7O))
        {
            if (! _count1I) 
            {
                _count1I = 1;
                _count1_Value = _count1_Value + 1;
            }
        }
         else 
        {
            _count1I = 0;
        }
    }
    _count1MaxLO = _count1_Value >= 7;
    if ((_count1_Value) == (6)) 
    {
        _dispTempLength1 = ((String("MENU"))).length();
        if (_disp5oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp5oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((String("MENU")));
    }
     else 
    {
        if (_disp5oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp5oldLength = 0;
        }
    }
    _Terminal_165493977 = (_count1_Value) == (6);
    if ((_count1_Value) == (6)) 
    {
        _tempVariable_bool  =  1;
        if (! _MenuBlock_158695770_OEIS) 
        {
            _MenuBlock_158695770_OEIS = 1;
        }
        _tempVariable_int = pgm_read_byte(&_menuParametrsArray[((_MainMenus[0].currentItem).startInArrayIndex)+10]);
        _MenuBlock_158695770_MNO = _readStringFromProgmem ((char*)pgm_read_word(&(_flprogMenuStringsArray[_tempVariable_int - 1])));
        _MenuBlock_158695770_VNO = _menuOutputValueString (0);
    }
     else 
    {
        _tempVariable_bool  =  0;
        if (_MenuBlock_158695770_OEIS)
        {
            _MenuBlock_158695770_OEIS = 0;
        }
        _MenuBlock_158695770_MNO = "";
        _MenuBlock_158695770_VNO = "";
    }
    if(!(_bounseInputD6O)) 
    {
         if (! _MenuBlock_158695770_OMUIS) 
        {
            _MenuBlock_158695770_OMUIS = 1;
            if(_tempVariable_bool)
            {
                  _menuUpEvents(0);
            }
        }
    }
     else 
    {
        _MenuBlock_158695770_OMUIS = 0;
    }
    if(!(_bounseInputD5O)) 
    {
         if (! _MenuBlock_158695770_OMDIS) 
        {
            _MenuBlock_158695770_OMDIS = 1;
            if(_tempVariable_bool)
            {
                   _menuDownEvents(0);
            }
        }
    }
     else 
    {
        _MenuBlock_158695770_OMDIS = 0;
    }
    if(!(_bounseInputD4O)) 
    {
         if (! _MenuBlock_158695770_OVUIS) 
        {
            _MenuBlock_158695770_OVUIS = 1;
            if(_tempVariable_bool)
            {
                _valueUpEvents(0);
                _menuUpdateToEEpromItems();
            }
        }
    }
     else 
    {
        _MenuBlock_158695770_OVUIS = 0;
    }
    if(!(_bounseInputD3O)) 
    {
         if (! _MenuBlock_158695770_OVDIS) 
        {
            _MenuBlock_158695770_OVDIS = 1;
            if(_tempVariable_bool)
            {
                _valueDownEvents(0);
                _menuUpdateToEEpromItems();
            }
        }
    }
     else 
    {
        _MenuBlock_158695770_OVDIS = 0;
    }
    if ((_count1_Value) == (6)) 
    {
        _dispTempLength1 = ((((_MenuBlock_158695770_MNO) + (String(" ")) + (_MenuBlock_158695770_VNO)))).length();
        if (_disp1oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp1oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 1);
        _lcd1.print((((_MenuBlock_158695770_MNO) + (String(" ")) + (_MenuBlock_158695770_VNO))));
    }
     else 
    {
        if (_disp1oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp1oldLength = 0;
        }
    }
    if ((Voltage_48176999_1) <= ((_menuValueArray_float[1]))) 
    {
        if (! _gen9I)
        {
            _gen9I = 1;
            _gen9O = 1;
            _gen9P = millis();
        }
    }
     else 
    {
        _gen9I = 0 ;
        _gen9O= 0;
    }
     if (_gen9I &&  _gen9O)   _gen9O = !(flprog::isTimer(_gen9P , 500));
    if(_gen9O) _trgr2 = 0;
    if((((_count1_Value) == (5)) && (!(_bounseInputD2O)) && ((Voltage_48176999_1) >= ((_menuValueArray_float[2]))))) _trgr2 = 1;
    if (_trgr2) 
    {
         if (! _gen8I) 
        {
            _gen8I = 1;
            _gen8O = 1;
            _gen8P = millis();
        }
    }
     else 
    {
        _gen8I = 0 ;
        _gen8O= 0;
    }
    if (_gen8I) 
    {
          if (flprog::isTimer (_gen8P , 500)) 
        {
             _gen8P = millis();
            _gen8O = ! _gen8O;
        }
    }
    if (_gtv6)
    {
        _count8_Value = 0;
    }
     else 
    {
        if (_gen8O)
        {
            if (! _count8I) 
            {
                _count8I = 1;
                _count8_Value = _count8_Value + 1;
            }
        }
         else 
        {
            _count8I = 0;
        }
    }
    _count8MaxLO = _count8_Value >= 10;
    _gtv6 = _count8MaxLO;
    if (_gtv5)
    {
        _count6_Value = 0;
    }
     else 
    {
        if (_gen8O)
        {
            if (! _count6I) 
            {
                _count6I = 1;
                _count6_Value = _count6_Value + 1;
            }
        }
         else 
        {
            _count6I = 0;
        }
    }
    _count6MaxLO = _count6_Value >= 60;
    _gtv5 = _count6MaxLO;
    if (0)
    {
        _count7_Value = 0;
    }
     else 
    {
        if (_gtv5)
        {
            if (! _count7I) 
            {
                _count7I = 1;
                _count7_Value = _count7_Value + 1;
            }
        }
         else 
        {
            _count7I = 0;
        }
    }
    if ((_count1_Value) == (5)) 
    {
        _dispTempLength1 = (((((String(_count7_Value, DEC))) + (String(":")) + ((String(_count6_Value, DEC))) + (String(" ")) + (String("Cb=")) + ((_floatToStringWitRaz((readFloatFromEEPROM(23, 0, 0x0)),1))) + (String("A/h"))))).length();
        if (_disp12oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp12oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 1);
        _lcd1.print(((((String(_count7_Value, DEC))) + (String(":")) + ((String(_count6_Value, DEC))) + (String(" ")) + (String("Cb=")) + ((_floatToStringWitRaz((readFloatFromEEPROM(23, 0, 0x0)),1))) + (String("A/h")))));
    }
     else 
    {
        if (_disp12oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp12oldLength = 0;
        }
    }
    if (_gtv6)
    {
        if (! _count9I) 
        {
            _count9I = 1;
            _count9_Value = _count9_Value + 1;
        }
    }
     else 
    {
        _count9I = 0;
    }
    if(((_gen9O) || ((((Voltage_48176999_1) <= ((_menuValueArray_float[1]))) && (!(_bounseInputD2O))))))
    {
         if(!_SEEPR1OSN)
        {
            (updateFloatToEEPROM(23, 0, 0x0, (((_count9_Value)*(Current_48176999_1))/(-6.00))));
            _SEEPR1OSN=1;
        }
    }
    else
    {
         if(_SEEPR1OSN)
        {
            _SEEPR1OSN=0;
        }
    }
    if ((_count1_Value) == (5)) 
    {
        _dispTempLength1 = ((((String("Cbat= ")) + ((_floatToStringWitRaz(((_count9_Value)*(Current_48176999_1))/(-6.00),1))) + (String("A/h"))))).length();
        if (_disp11oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp11oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("Cbat= ")) + ((_floatToStringWitRaz(((_count9_Value)*(Current_48176999_1))/(-6.00),1))) + (String("A/h")))));
    }
     else 
    {
        if (_disp11oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp11oldLength = 0;
        }
    }
    if ((Voltage_48176999_1) <= ((_menuValueArray_float[1]))) 
    {
        if (! _gen1I)
        {
            _gen1I = 1;
            _gen1O = 1;
            _gen1P = millis();
        }
    }
     else 
    {
        _gen1I = 0 ;
        _gen1O= 0;
    }
     if (_gen1I &&  _gen1O)   _gen1O = !(flprog::isTimer(_gen1P , 500));
    if (_gen1O)
    {
        if (! _count5I) 
        {
            _count5I = 1;
            _count5_Value = _count5_Value + 1;
        }
    }
     else 
    {
        _count5I = 0;
    }
    _Terminal_205090452 = (_count5_Value) <= ((_menuValueArray_int[0]));
    if ((_count1_Value) == (4)) 
    {
        _dispTempLength1 = ((((String("CH/DIS ")) + ((String(_count5_Value, DEC)))))).length();
        if (_disp10oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp10oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 1);
        _lcd1.print((((String("CH/DIS ")) + ((String(_count5_Value, DEC))))));
    }
     else 
    {
        if (_disp10oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp10oldLength = 0;
        }
    }
    if ((_count1_Value) == (4)) 
    {
        _dispTempLength1 = ((((String("U=")) + ((_floatToStringWitRaz(Voltage_48176999_1,1))) + (String("V ")) + (String("I=")) + ((_floatToStringWitRaz(Current_48176999_1,1))) + (String("A "))))).length();
        if (_disp3oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp3oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("U=")) + ((_floatToStringWitRaz(Voltage_48176999_1,1))) + (String("V ")) + (String("I=")) + ((_floatToStringWitRaz(Current_48176999_1,1))) + (String("A ")))));
    }
     else 
    {
        if (_disp3oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp3oldLength = 0;
        }
    }
    _Terminal_94219908 = (_count1_Value) == (4);
    if ((_count1_Value) == (3)) 
    {
        _dispTempLength1 = ((((String("Rb= ")) + ((_floatToStringWitRaz((((readFloatFromEEPROM(19, 0, 0x0)))-(Voltage_48176999_1))/((Current_48176999_1)*(-1.00)),4))) + (String("Ohm"))))).length();
        if (_disp4oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp4oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("Rb= ")) + ((_floatToStringWitRaz((((readFloatFromEEPROM(19, 0, 0x0)))-(Voltage_48176999_1))/((Current_48176999_1)*(-1.00)),4))) + (String("Ohm")))));
    }
     else 
    {
        if (_disp4oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp4oldLength = 0;
        }
    }
    if ((((_count1_Value) == (3)) && (!(_bounseInputD2O))))
    {
         if (_tim2I) 
        {
             if (flprog::isTimer(_tim2P, 1000)) 
            {
                _tim2O = 1;
            }
        }
         else 
        {
            _tim2I =1;
            _tim2P = millis();
        }
    }
     else 
    {
        _tim2O = 0;
        _tim2I = 0;
    }
    if((((_count1_Value) == (3)) && (!(_bounseInputD2O))))
    {
         if(!_SEEPR2OSN)
        {
            (updateFloatToEEPROM(19, 0, 0x0, (Voltage_48176999_1)));
            _SEEPR2OSN=1;
        }
    }
    else
    {
         if(_SEEPR2OSN)
        {
            _SEEPR2OSN=0;
        }
    }
    _Terminal_225282125 = (_count1_Value) == (3);
    _Terminal_42744769 = (_count1_Value) == (2);
    _Terminal_104140634 = (_count1_Value) == (1);
    _Terminal_154538624 = (_count1_Value) == (0);
    _gtv1 = _count1MaxLO;
}
String  _floatToStringWitRaz(float value, int raz)
{
    return String(value,raz);
}
String _readStringFromProgmem (char *string)
{
    String result = String("");
    while (pgm_read_byte(string)!='\0')
    {
        result=result+ char(pgm_read_byte(string));
        	string++;
        	
    }
    return result;
}
void _menuUpEvents (int menuIndex)
{
    int tempIndex = pgm_read_byte(&_menuParametrsArray[((_MainMenus[menuIndex]).currentItem).startInArrayIndex]);
    int parIndex = pgm_read_byte(&_menuParametrsArray[ (((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+5]);
    int parentStartIndex;
    int parentStopIndex;
    if (parIndex == 0) 
    {
        parentStartIndex = (_MainMenus[menuIndex]).startIndex;
        parentStopIndex =(_MainMenus[menuIndex]).stopIndex;
    }
    else 
    {
        parentStartIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex - 1]).startInArrayIndex)+3]);
        parentStopIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex-1]).startInArrayIndex)+4]);
    }
    if (tempIndex == parentStartIndex) 
    {
        if((_MainMenus[menuIndex]).isSwitchMenuAroundRing) 
        {
            (_MainMenus[menuIndex]).currentItem = _MenuItems[parentStopIndex -1];
            return;
        }
         else
        {
            return;
        }
    }
    (_MainMenus[menuIndex]).currentItem = _MenuItems[tempIndex - 2];
    return;
}
void _menuDownEvents (int menuIndex)
{
    int tempIndex = pgm_read_byte(&_menuParametrsArray[((_MainMenus[menuIndex]).currentItem).startInArrayIndex]);
    int parIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+5]);
    int parentStartIndex;
    int parentStopIndex;
    if (parIndex == 0) 
    {
        parentStartIndex = (_MainMenus[menuIndex]).startIndex;
        parentStopIndex =(_MainMenus[menuIndex]).stopIndex;
    }
    else 
    {
        parentStartIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex-1]).startInArrayIndex)+3]);
        parentStopIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex-1]).startInArrayIndex)+4]);
    }
    if (tempIndex == parentStopIndex) 
    {
        if((_MainMenus[menuIndex]).isSwitchMenuAroundRing) 
        {
            (_MainMenus[menuIndex]).currentItem = _MenuItems[parentStartIndex -1];
            return;
        }
         else
        {
            return;
        }
    }
    (_MainMenus[menuIndex]).currentItem = _MenuItems[tempIndex];
    return;
}
void _valueUpEvents (int menuIndex)
{
    int valIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+2]);
    int itemType = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+1]);
    int indexMax = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+6]);
    int indexStep = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+8]);
    if (itemType == 4) 
    {
        if (! indexMax == 0) 
        {
             if (! (int(pgm_read_word(&_menuConstantValuesArray_int[indexMax -1])) > int(_menuValueArray_int[valIndex -1]))) 
            {
                return;
            }
        }
        _menuValueArray_int[valIndex -1] = _menuValueArray_int[valIndex -1] + (pgm_read_word(&_menuConstantValuesArray_int[indexStep -1]));
    }
    if (itemType == 8) 
    {
        if (! indexMax == 0) 
        {
             if (! (float(pgm_read_float(&_menuConstantValuesArray_float[indexMax -1])) > float(_menuValueArray_float[valIndex -1]))) 
            {
                return;
            }
        }
        _menuValueArray_float[valIndex -1] = _menuValueArray_float[valIndex -1] + (pgm_read_float(&_menuConstantValuesArray_float[indexStep -1]));
    }
}
void _valueDownEvents (int menuIndex)
{
    int valIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+2]);
    int itemType = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+1]);
    int indexMin = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+7]);
    int indexStep = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+8]);
    if (itemType == 4) 
    {
        if (! indexMin == 0) 
        {
             if (! ((int(pgm_read_word(&_menuConstantValuesArray_int[indexMin - 1]))) < int(_menuValueArray_int[valIndex - 1]))) 
            {
                return;
            }
        }
        _menuValueArray_int[valIndex - 1] = _menuValueArray_int[valIndex - 1] - (pgm_read_word(&_menuConstantValuesArray_int[indexStep - 1]));
    }
    if (itemType == 8) 
    {
        if (! indexMin == 0) 
        {
             if (! ((float(pgm_read_float(&_menuConstantValuesArray_float[indexMin - 1]))) < float(_menuValueArray_float[valIndex - 1]))) 
            {
                return;
            }
        }
        _menuValueArray_float[valIndex - 1] = _menuValueArray_float[valIndex - 1] - (pgm_read_float(&_menuConstantValuesArray_float[indexStep - 1]));
    }
}
String _menuOutputValueString (int menuIndex)
{
    int itemType = pgm_read_byte(&_menuParametrsArray[ (((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+1]);
    int valIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+2]);
    int indexMin = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+7]);
    int indexMax = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+6]);
    if(valIndex == 0)
    {
         return "";
    }
    int convFormat = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+9]);
    if(itemType == 4) 
    {
         return _convertNamber(itemType, convFormat, valIndex, indexMax, indexMin);
    }
    if(itemType == 8) 
    {
         return _convertFloat(itemType, convFormat, valIndex, indexMax, indexMin);
    }
    return "";
}
void _menuUpdateToEEpromItems()
{
    (updateFloatToEEPROM(1, 0, 0x0, ((_menuValueArray_float[0]))));
    (updateFloatToEEPROM(5, 0, 0x0, ((_menuValueArray_float[1]))));
    (updateFloatToEEPROM(9, 0, 0x0, ((_menuValueArray_float[2]))));
    (updateFloatToEEPROM(13, 0, 0x0, ((_menuValueArray_float[3]))));
    (updateIntegerToEEPROM(17, 0, 0x0, ((_menuValueArray_int[0]))));
}
String _convertNamber(int itemType, int convFormat, int valIndex, int indexMax, int indexMin)
{
    if (itemType== 4) 
    {
        if (convFormat == 4) 
        {
             return String((_menuValueArray_int[valIndex - 1 ]),DEC);
        }
        if (convFormat == 5) 
        {
             return String((_menuValueArray_int[valIndex - 1]),HEX);
        }
        if (convFormat == 6) 
        {
             return String((_menuValueArray_int[valIndex -1]),BIN);
        }
    }
    if (itemType== 8) 
    {
        if (convFormat == 4) 
        {
             return String((_menuValueArray_float[valIndex - 1 ]),DEC);
        }
        if (convFormat == 5) 
        {
             return String((_menuValueArray_float[valIndex - 1]),HEX);
        }
        if (convFormat == 6) 
        {
             return String((_menuValueArray_float[valIndex -1]),BIN);
        }
    }
    return "";
}
String _convertFloat(int itemType, int convFormat, int valIndex , int indexMax, int indexMin)
{
    return String((_menuValueArray_float[valIndex -1]),convFormat);
}
void get_Parametr__48176999_1()
{
    	uint16_t vallue; // объявляем промеж переменную
          vallue = 0;
    	int16_t pptt; // объявляем 2 промеж переменную
    	wire_Read_48176999_1(0x01, &vallue); //считываем в промеж переменную регистр шунта
    	pptt = (int16_t)vallue; // получаем напряжение на шунте, в *10мкВ
    	V_Shunt_48176999_1 = pptt * 0.010; // получаем напряжение на шунте, тип Float, в мВ
    	Current_48176999_1 = V_Shunt_48176999_1 * 10 / R_shunt_48176999_1; // получаем амперы
          vallue = 0;
    	wire_Read_48176999_1(0x02, &vallue); //считываем в промеж переменную регистр напряжения
    	int16_t vollt = ((int16_t)((vallue >> 3) * 4)); // сдвигаем на 3 бита и умножаем на 4
    	Voltage_48176999_1 = vollt * 0.001; // получаем флоат, переводим мВ в Вольты
    	if ((V_Shunt_48176999_1 >319) | (V_Shunt_48176999_1 < -319)) MAX_Current_48176999_1 = 1;
    	else MAX_Current_48176999_1=0;
}
void wire_Read_48176999_1(uint8_t reg, uint16_t *value)
{
    	Wire.beginTransmission(64);
    Wire.write(reg);
    	Wire.endTransmission();
    	delay(50);
    	Wire.requestFrom((uint8_t) 64, (uint8_t)2);
    *value = ((Wire.read() << 8) | Wire.read());
}
byte readByteFromEEPROM(int addres, byte bitAddres, byte chipAddres)
{
    return EEPROM.read(addres);
}
void updateByteToEEPROM(int addres, byte bitAddres, byte chipAddres, byte value)
{
    return EEPROM.update(addres, value);
}
int readIntegerFromEEPROM(int addres, byte bitAddres, byte chipAddres)
{
    byte hight = readByteFromEEPROM(addres,  bitAddres,  chipAddres);
    byte low = readByteFromEEPROM((addres+1),  bitAddres,  chipAddres);
    return  word(hight, low);
}
void updateIntegerToEEPROM(int addres, byte bitAddres, byte chipAddres, int value)
{
    updateByteToEEPROM(addres,  bitAddres,  chipAddres, highByte(value));
    updateByteToEEPROM((addres+1),  bitAddres,  chipAddres, lowByte(value));
}
float readFloatFromEEPROM(int addres, byte bitAddres, byte chipAddres)
{
    byte x[4];
    for(byte i = 0; i < 4; i++) 
    {
         x[i] = readByteFromEEPROM((addres+i),  bitAddres,  chipAddres);
    }
    float *y = (float *)&x;
    return y[0];
}
void updateFloatToEEPROM(int addres, byte bitAddres, byte chipAddres, float value)
{
    byte *x = (byte *)&value;
    for(byte i = 0; i < 4; i++) 
    {
        updateByteToEEPROM((addres+i),  bitAddres,  chipAddres, x[i]);
    }
}
