#include <Wire.h>
#include <LiquidCrystal.h>
#include <EEPROM.h>
LiquidCrystal _lcd1(12, 11, 10, 9, 8, 7);
int _dispTempLength1=0;
boolean _isNeedClearDisp1;
const int _menuParametrsArray[]  PROGMEM =  {1, 4, 3, 0, 0, 0, 4, 8, 1, 4, 3, 0, 2, 4, 1, 0, 0, 0, 2, 1, 1, 4, 1, 0, 3, 4, 6, 0, 0, 0, 6, 1, 1, 4, 6, 0, 4, 4, 5, 0, 0, 0, 5, 7, 1, 4, 5, 0, 5, 4, 4, 0, 0, 0, 3, 7, 1, 4, 4, 0, 6, 4, 2, 0, 0, 0, 3, 7, 1, 4, 2, 0};
int _menuValueArray_int[6];
const int _menuConstantValuesArray_int[]  PROGMEM =  {1, 12, 59, 55, 23, 31, 0, 21};
const char _flprogMenuNameString1[] PROGMEM = "MOU";
const char _flprogMenuNameString2[] PROGMEM = "SEC";
const char _flprogMenuNameString3[] PROGMEM = "YER";
const char _flprogMenuNameString4[] PROGMEM = "MIN";
const char _flprogMenuNameString5[] PROGMEM = "HOUR";
const char _flprogMenuNameString6[] PROGMEM = "DAY";
const char* const _flprogMenuStringsArray[] PROGMEM = { _flprogMenuNameString1,  _flprogMenuNameString2,  _flprogMenuNameString3,  _flprogMenuNameString4,  _flprogMenuNameString5,  _flprogMenuNameString6};
struct _menuItemStricture 
{
     int startInArrayIndex;
}
;
struct _menuMainStricture 
{
    int startIndex;
    int stopIndex;
    bool isSwitchMenuAroundRing;
    _menuItemStricture  currentItem;
}
;
_menuItemStricture _MenuItems[6];
_menuMainStricture _MainMenus[1];
struct _I2CRealRimeClockTime
{
    byte seconds = 0;
    byte minutes = 0;
    byte Hours = 0;
    byte weekday = 0;
    byte day = 0;
    byte month = 0;
    byte year = 0;
    unsigned long startTime = 0;
}
;
_I2CRealRimeClockTime _RTC1;
bool _gtv1;
bool _gtv3;
bool _gtv2;
bool _gtv4;
bool _SEEPR24OSN = 0;
bool _count1I = 0;
int _count1_Value = 0;
bool _count1MaxLO = 0;
bool _gen2I = 0;
bool _gen2O = 0;
unsigned long _gen2P = 0UL;
bool _Terminal_90107467;
bool _bounseInputD6S = 0;
bool _bounseInputD6O = 0;
unsigned long _bounseInputD6P = 0UL;
bool _trgt2 = 0;
bool _trgt2I = 0;
bool _SEEPR8OSN = 0;
bool _Terminal_46394530;
bool _SEEPR21OSN = 0;
bool _bounseInputD3S = 0;
bool _bounseInputD3O = 0;
unsigned long _bounseInputD3P = 0UL;
bool _RTCAlO6 = 0;
int _disp3oldLength = 0;
bool _Terminal_78455792;
int _disp8oldLength = 0;
bool _bounseInputD16S = 0;
bool _bounseInputD16O = 0;
unsigned long _bounseInputD16P = 0UL;
int _disp4oldLength = 0;
bool _RTCAlO3 = 0;
bool _Terminal_83449367;
bool _bounseInputD17S = 0;
bool _bounseInputD17O = 0;
unsigned long _bounseInputD17P = 0UL;
bool _RTCAlO7 = 0;
int _disp11oldLength = 0;
bool _SEEPR5OSN = 0;
bool _Terminal_75126742;
bool _RTCAlO10 = 0;
bool _SEEPR20OSN = 0;
int _disp14oldLength = 0;
bool _bounseInputD14S = 0;
bool _bounseInputD14O = 0;
unsigned long _bounseInputD14P = 0UL;
String _RTC1_GetTime2_StrOut;
bool _count4I = 0;
int _count4_Value = 0;
bool _count4MaxLO = 0;
bool _SEEPR6OSN = 0;
bool _SEEPR17OSN = 0;
bool _RTCAlO1 = 0;
bool _SEEPR23OSN = 0;
bool _gen1I = 0;
bool _gen1O = 0;
unsigned long _gen1P = 0UL;
bool _Terminal_86778417;
int _disp7oldLength = 0;
bool _RTCAlO5 = 0;
bool _Terminal_43065480;
bool _RTCAlO14 = 0;
bool _SEEPR11OSN = 0;
bool _SEEPR14OSN = 0;
bool _SEEPR26OSN = 0;
bool _SEEPR3OSN = 0;
bool _SEEPR16OSN = 0;
int _disp1oldLength = 0;
bool _Terminal_80120317;
int _disp9oldLength = 0;
bool _bounseInputD15S = 0;
bool _bounseInputD15O = 0;
unsigned long _bounseInputD15P = 0UL;
bool _bounseInputD5S = 0;
bool _bounseInputD5O = 0;
unsigned long _bounseInputD5P = 0UL;
bool _bounseInputD1S = 0;
bool _bounseInputD1O = 0;
unsigned long _bounseInputD1P = 0UL;
bool _SEEPR4OSN = 0;
bool _Terminal_85113892;
bool _RTCAlO8 = 0;
bool _Terminal_88442942;
bool _bounseInputD2S = 0;
bool _bounseInputD2O = 0;
unsigned long _bounseInputD2P = 0UL;
bool _SEEPR10OSN = 0;
bool _SEEPR19OSN = 0;
int _disp12oldLength = 0;
int _disp6oldLength = 0;
bool _RTCAlO11 = 0;
bool _Terminal_44730005;
int _disp15oldLength = 0;
int _disp2oldLength = 0;
bool _SEEPR9OSN = 0;
bool _SEEPR22OSN = 0;
bool _count2I = 0;
bool _count2_SCST = 0;
int _count2_Value = 0;
bool _count2MaxLO = 0;
bool _RTCAlO2 = 0;
bool _RTCAlO13 = 0;
bool _SEEPR12OSN = 0;
bool _SEEPR25OSN = 0;
bool _RTCAlO9 = 0;
int _disp13oldLength = 0;
bool _SEEPR2OSN = 0;
bool _SEEPR13OSN = 0;
bool _bounseInputD13S = 0;
bool _bounseInputD13O = 0;
unsigned long _bounseInputD13P = 0UL;
bool _SEEPR15OSN = 0;
int _disp16oldLength = 0;
bool _Terminal_76791267;
bool _SEEPR1OSN = 0;
int _disp5oldLength = 0;
String _MenuBlock_248902600_MNO;
String _MenuBlock_248902600_VNO;
bool _MenuBlock_248902600_OEIS = 0;
bool _MenuBlock_248902600_OMUIS = 0;
bool _MenuBlock_248902600_OMDIS = 0;
bool _MenuBlock_248902600_OVUIS = 0;
bool _MenuBlock_248902600_OVDIS = 0;
int _disp10oldLength = 0;
bool _Terminal_81784842;
bool _RTCST_Ost2 = 0;
bool _SEEPR7OSN = 0;
bool _SEEPR18OSN = 0;
bool _tempVariable_bool;
int _tempVariable_int;
void setup()
{
    pinMode(14, INPUT_PULLUP);
    pinMode(15, INPUT_PULLUP);
    pinMode(2, INPUT_PULLUP);
    pinMode(3, INPUT_PULLUP);
    pinMode(6, INPUT_PULLUP);
    pinMode(5, INPUT_PULLUP);
    pinMode(1, INPUT_PULLUP);
    pinMode(16, INPUT_PULLUP);
    pinMode(17, INPUT_PULLUP);
    pinMode(13, INPUT_PULLUP);
    pinMode(4, OUTPUT);
    digitalWrite(4, 0);
    pinMode(0, OUTPUT);
    digitalWrite(0, 0);
    Wire.begin();
    delay(10);
    Wire.beginTransmission(68);
    Wire.write(0x0E);
    Wire.write(B00000000);
    Wire.write(B10001000);
    Wire.endTransmission();
    _RTC1.startTime = millis() - 1000;
    _lcd1.begin(20, 2);
    _bounseInputD6O =  digitalRead(6);
    _bounseInputD13O =  digitalRead(13);
    _bounseInputD5O =  digitalRead(5);
    _bounseInputD17O =  digitalRead(17);
    _bounseInputD1O =  digitalRead(1);
    _bounseInputD3O =  digitalRead(3);
    _bounseInputD16O =  digitalRead(16);
    _bounseInputD2O =  digitalRead(2);
    _bounseInputD14O =  digitalRead(14);
    _bounseInputD15O =  digitalRead(15);
    _MenuItems[0].startInArrayIndex = 0;
    _MenuItems[1].startInArrayIndex = 12;
    _MenuItems[2].startInArrayIndex = 24;
    _MenuItems[3].startInArrayIndex = 36;
    _MenuItems[4].startInArrayIndex = 48;
    _MenuItems[5].startInArrayIndex = 60;
    _MainMenus[0].startIndex = 1;
    _MainMenus[0].isSwitchMenuAroundRing = 0;
    _MainMenus[0].stopIndex = 6;
    _MainMenus[0].currentItem = _MenuItems[0];
}
void loop()
{
    if (_isNeedClearDisp1) 
    {
        _lcd1.clear();
        _isNeedClearDisp1= 0;
    }
    bool  _bounceInputTmpD6 =  (digitalRead (6));
    if (_bounseInputD6S)
    {
        if (millis() >= (_bounseInputD6P + 40))
        {
            _bounseInputD6O= _bounceInputTmpD6;
            _bounseInputD6S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD6 != _bounseInputD6O)
        {
            _bounseInputD6S=1;
            _bounseInputD6P = millis();
        }
    }
    bool  _bounceInputTmpD13 =  (digitalRead (13));
    if (_bounseInputD13S)
    {
        if (millis() >= (_bounseInputD13P + 40))
        {
            _bounseInputD13O= _bounceInputTmpD13;
            _bounseInputD13S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD13 != _bounseInputD13O)
        {
            _bounseInputD13S=1;
            _bounseInputD13P = millis();
        }
    }
    bool  _bounceInputTmpD5 =  (digitalRead (5));
    if (_bounseInputD5S)
    {
        if (millis() >= (_bounseInputD5P + 40))
        {
            _bounseInputD5O= _bounceInputTmpD5;
            _bounseInputD5S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD5 != _bounseInputD5O)
        {
            _bounseInputD5S=1;
            _bounseInputD5P = millis();
        }
    }
    bool  _bounceInputTmpD17 =  (digitalRead (17));
    if (_bounseInputD17S)
    {
        if (millis() >= (_bounseInputD17P + 40))
        {
            _bounseInputD17O= _bounceInputTmpD17;
            _bounseInputD17S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD17 != _bounseInputD17O)
        {
            _bounseInputD17S=1;
            _bounseInputD17P = millis();
        }
    }
    bool  _bounceInputTmpD1 =  (digitalRead (1));
    if (_bounseInputD1S)
    {
        if (millis() >= (_bounseInputD1P + 40))
        {
            _bounseInputD1O= _bounceInputTmpD1;
            _bounseInputD1S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD1 != _bounseInputD1O)
        {
            _bounseInputD1S=1;
            _bounseInputD1P = millis();
        }
    }
    bool  _bounceInputTmpD3 =  (digitalRead (3));
    if (_bounseInputD3S)
    {
        if (millis() >= (_bounseInputD3P + 40))
        {
            _bounseInputD3O= _bounceInputTmpD3;
            _bounseInputD3S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD3 != _bounseInputD3O)
        {
            _bounseInputD3S=1;
            _bounseInputD3P = millis();
        }
    }
    bool  _bounceInputTmpD16 =  (digitalRead (16));
    if (_bounseInputD16S)
    {
        if (millis() >= (_bounseInputD16P + 40))
        {
            _bounseInputD16O= _bounceInputTmpD16;
            _bounseInputD16S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD16 != _bounseInputD16O)
        {
            _bounseInputD16S=1;
            _bounseInputD16P = millis();
        }
    }
    bool  _bounceInputTmpD2 =  (digitalRead (2));
    if (_bounseInputD2S)
    {
        if (millis() >= (_bounseInputD2P + 40))
        {
            _bounseInputD2O= _bounceInputTmpD2;
            _bounseInputD2S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD2 != _bounseInputD2O)
        {
            _bounseInputD2S=1;
            _bounseInputD2P = millis();
        }
    }
    bool  _bounceInputTmpD14 =  (digitalRead (14));
    if (_bounseInputD14S)
    {
        if (millis() >= (_bounseInputD14P + 40))
        {
            _bounseInputD14O= _bounceInputTmpD14;
            _bounseInputD14S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD14 != _bounseInputD14O)
        {
            _bounseInputD14S=1;
            _bounseInputD14P = millis();
        }
    }
    bool  _bounceInputTmpD15 =  (digitalRead (15));
    if (_bounseInputD15S)
    {
        if (millis() >= (_bounseInputD15P + 40))
        {
            _bounseInputD15O= _bounceInputTmpD15;
            _bounseInputD15S=0;
        }
    }
    else
    {
        if (_bounceInputTmpD15 != _bounseInputD15O)
        {
            _bounseInputD15S=1;
            _bounseInputD15P = millis();
        }
    }
    //Плата:1
//Наименование:ГАЗ
    if (!(_bounseInputD14O))
    {
        _count4_Value = (readIntegerFromEEPROM(0, 0, 0x0));
    }
     else 
    {
        if (_gtv1)
        {
            _count4_Value = 0;
        }
         else 
        {
            if (!(!(_bounseInputD15O)))
            {
                if (! _count4I) 
                {
                    _count4I = 1;
                    _count4_Value = _count4_Value + 1;
                }
            }
             else 
            {
                _count4I = 0;
            }
        }
    }
    _count4MaxLO = _count4_Value >= 100;
    if(!(_bounseInputD15O))
    {
         if(!_SEEPR13OSN)
        {
            (updateIntegerToEEPROM(0, 0, 0x0, (_count4_Value)));
            _SEEPR13OSN=1;
        }
    }
    else
    {
         if(_SEEPR13OSN)
        {
            _SEEPR13OSN=0;
        }
    }
    if (!(_bounseInputD14O))
    {
        _count1_Value = (readIntegerFromEEPROM(2, 0, 0x0));
    }
     else 
    {
        if (_gtv3)
        {
            _count1_Value = 0;
        }
         else 
        {
            if (_count4MaxLO)
            {
                if (! _count1I) 
                {
                    _count1I = 1;
                    _count1_Value = _count1_Value + 1;
                }
            }
             else 
            {
                _count1I = 0;
            }
        }
    }
    _count1MaxLO = _count1_Value >= 99000;
    if(!(_bounseInputD15O))
    {
         if(!_SEEPR1OSN)
        {
            (updateIntegerToEEPROM(2, 0, 0x0, (_count1_Value)));
            _SEEPR1OSN=1;
        }
    }
    else
    {
         if(_SEEPR1OSN)
        {
            _SEEPR1OSN=0;
        }
    }
    if (_Terminal_75126742) 
    {
        _dispTempLength1 = ((((String("G ")) + ((String((readIntegerFromEEPROM(2, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(0, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp10oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp10oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("G ")) + ((String((readIntegerFromEEPROM(2, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(0, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp10oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp10oldLength = 0;
        }
    }
    _gtv1 = _count4MaxLO;
    _gtv3 = _count1MaxLO;
    if (((analogRead (7))) <= (717)) 
    {
         if (! _gen2I) 
        {
            _gen2I = 1;
            _gen2O = 1;
            _gen2P = millis();
        }
    }
     else 
    {
        _gen2I = 0 ;
        _gen2O= 0;
    }
    if (_gen2I) 
    {
          if (_isTimer (_gen2P , 300)) 
        {
             _gen2P = millis();
            _gen2O = ! _gen2O;
        }
    }
    digitalWrite(4, !(_gen2O));
    if (((analogRead (7))) > (800)) 
    {
        if (! _gen1I)
        {
            _gen1I = 1;
            _gen1O = 1;
            _gen1P = millis();
        }
    }
     else 
    {
        _gen1I = 0 ;
        _gen1O= 0;
    }
     if (_gen1I &&  _gen1O)   _gen1O = !(_isTimer(_gen1P , 100));
    digitalWrite(0, _gen1O);
    //Плата:2
//Наименование:Запись по месяцам ЯНВАРЬ - ИЮНЬ
     if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO14 = 1;
        if (_RTC1.day != 31) 
        {
             _RTCAlO14 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO14 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO14 = 0;
        }
        if (_RTC1.month != 1) 
        {
             _RTCAlO14 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO14 = 0;
        }
    }
     else 
    {
        _RTCAlO14 = 0;
    }
    if(_RTCAlO14)
    {
         if(!_SEEPR2OSN)
        {
            (updateIntegerToEEPROM(4, 0, 0x0, (_count1_Value)));
            _SEEPR2OSN=1;
        }
    }
    else
    {
         if(_SEEPR2OSN)
        {
            _SEEPR2OSN=0;
        }
    }
    if(_RTCAlO14)
    {
         if(!_SEEPR3OSN)
        {
            (updateIntegerToEEPROM(6, 0, 0x0, (_count4_Value)));
            _SEEPR3OSN=1;
        }
    }
    else
    {
         if(_SEEPR3OSN)
        {
            _SEEPR3OSN=0;
        }
    }
    if (_Terminal_76791267) 
    {
        _dispTempLength1 = ((((String("JAN ")) + ((String((readIntegerFromEEPROM(4, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(6, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp4oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp4oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("JAN ")) + ((String((readIntegerFromEEPROM(4, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(6, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp4oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp4oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO1 = 1;
        if (_RTC1.day != 29) 
        {
             _RTCAlO1 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO1 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO1 = 0;
        }
        if (_RTC1.month != 2) 
        {
             _RTCAlO1 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO1 = 0;
        }
    }
     else 
    {
        _RTCAlO1 = 0;
    }
    if(_RTCAlO1)
    {
         if(!_SEEPR4OSN)
        {
            (updateIntegerToEEPROM(8, 0, 0x0, (_count1_Value)));
            _SEEPR4OSN=1;
        }
    }
    else
    {
         if(_SEEPR4OSN)
        {
            _SEEPR4OSN=0;
        }
    }
    if(_RTCAlO1)
    {
         if(!_SEEPR5OSN)
        {
            (updateIntegerToEEPROM(10, 0, 0x0, (_count4_Value)));
            _SEEPR5OSN=1;
        }
    }
    else
    {
         if(_SEEPR5OSN)
        {
            _SEEPR5OSN=0;
        }
    }
    if (_Terminal_78455792) 
    {
        _dispTempLength1 = ((((String("VEB ")) + ((String((readIntegerFromEEPROM(8, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(10, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp5oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp5oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("VEB ")) + ((String((readIntegerFromEEPROM(8, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(10, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp5oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp5oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO2 = 1;
        if (_RTC1.day != 31) 
        {
             _RTCAlO2 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO2 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO2 = 0;
        }
        if (_RTC1.month != 3) 
        {
             _RTCAlO2 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO2 = 0;
        }
    }
     else 
    {
        _RTCAlO2 = 0;
    }
    if(_RTCAlO2)
    {
         if(!_SEEPR6OSN)
        {
            (updateIntegerToEEPROM(12, 0, 0x0, (_count1_Value)));
            _SEEPR6OSN=1;
        }
    }
    else
    {
         if(_SEEPR6OSN)
        {
            _SEEPR6OSN=0;
        }
    }
    if(_RTCAlO2)
    {
         if(!_SEEPR7OSN)
        {
            (updateIntegerToEEPROM(14, 0, 0x0, (_count4_Value)));
            _SEEPR7OSN=1;
        }
    }
    else
    {
         if(_SEEPR7OSN)
        {
            _SEEPR7OSN=0;
        }
    }
    if (_Terminal_80120317) 
    {
        _dispTempLength1 = ((((String("MAR ")) + ((String((readIntegerFromEEPROM(12, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(14, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp6oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp6oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("MAR ")) + ((String((readIntegerFromEEPROM(12, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(14, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp6oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp6oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO3 = 1;
        if (_RTC1.day != 30) 
        {
             _RTCAlO3 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO3 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO3 = 0;
        }
        if (_RTC1.month != 4) 
        {
             _RTCAlO3 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO3 = 0;
        }
    }
     else 
    {
        _RTCAlO3 = 0;
    }
    if(_RTCAlO3)
    {
         if(!_SEEPR8OSN)
        {
            (updateIntegerToEEPROM(16, 0, 0x0, (_count1_Value)));
            _SEEPR8OSN=1;
        }
    }
    else
    {
         if(_SEEPR8OSN)
        {
            _SEEPR8OSN=0;
        }
    }
    if(_RTCAlO3)
    {
         if(!_SEEPR9OSN)
        {
            (updateIntegerToEEPROM(18, 0, 0x0, (_count4_Value)));
            _SEEPR9OSN=1;
        }
    }
    else
    {
         if(_SEEPR9OSN)
        {
            _SEEPR9OSN=0;
        }
    }
    if (_Terminal_81784842) 
    {
        _dispTempLength1 = ((((String("APR ")) + ((String((readIntegerFromEEPROM(16, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(18, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp7oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp7oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("APR ")) + ((String((readIntegerFromEEPROM(16, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(18, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp7oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp7oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO5 = 1;
        if (_RTC1.day != 31) 
        {
             _RTCAlO5 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO5 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO5 = 0;
        }
        if (_RTC1.month != 5) 
        {
             _RTCAlO5 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO5 = 0;
        }
    }
     else 
    {
        _RTCAlO5 = 0;
    }
    if(_RTCAlO5)
    {
         if(!_SEEPR10OSN)
        {
            (updateIntegerToEEPROM(20, 0, 0x0, (_count1_Value)));
            _SEEPR10OSN=1;
        }
    }
    else
    {
         if(_SEEPR10OSN)
        {
            _SEEPR10OSN=0;
        }
    }
    if(_RTCAlO5)
    {
         if(!_SEEPR11OSN)
        {
            (updateIntegerToEEPROM(22, 0, 0x0, (_count4_Value)));
            _SEEPR11OSN=1;
        }
    }
    else
    {
         if(_SEEPR11OSN)
        {
            _SEEPR11OSN=0;
        }
    }
    if (_Terminal_83449367) 
    {
        _dispTempLength1 = ((((String("MAI ")) + ((String((readIntegerFromEEPROM(20, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(22, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp8oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp8oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("MAI ")) + ((String((readIntegerFromEEPROM(20, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(22, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp8oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp8oldLength = 0;
        }
    }
    if (_Terminal_85113892) 
    {
        _dispTempLength1 = ((((String("JUN ")) + ((String((readIntegerFromEEPROM(24, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(26, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp9oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp9oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("JUN ")) + ((String((readIntegerFromEEPROM(24, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(26, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp9oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp9oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO6 = 1;
        if (_RTC1.day != 30) 
        {
             _RTCAlO6 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO6 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO6 = 0;
        }
        if (_RTC1.month != 6) 
        {
             _RTCAlO6 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO6 = 0;
        }
    }
     else 
    {
        _RTCAlO6 = 0;
    }
    if(_RTCAlO6)
    {
         if(!_SEEPR12OSN)
        {
            (updateIntegerToEEPROM(24, 0, 0x0, (_count1_Value)));
            _SEEPR12OSN=1;
        }
    }
    else
    {
         if(_SEEPR12OSN)
        {
            _SEEPR12OSN=0;
        }
    }
    if(_RTCAlO6)
    {
         if(!_SEEPR14OSN)
        {
            (updateIntegerToEEPROM(26, 0, 0x0, (_count4_Value)));
            _SEEPR14OSN=1;
        }
    }
    else
    {
         if(_SEEPR14OSN)
        {
            _SEEPR14OSN=0;
        }
    }
    //Плата:3
//Наименование:Запись июль - декабрь
    if (_Terminal_86778417) 
    {
        _dispTempLength1 = ((((String("JUL ")) + ((String((readIntegerFromEEPROM(28, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(30, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp11oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp11oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("JUL ")) + ((String((readIntegerFromEEPROM(28, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(30, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp11oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp11oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO13 = 1;
        if (_RTC1.day != 31) 
        {
             _RTCAlO13 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO13 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO13 = 0;
        }
        if (_RTC1.month != 7) 
        {
             _RTCAlO13 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO13 = 0;
        }
    }
     else 
    {
        _RTCAlO13 = 0;
    }
    if(_RTCAlO13)
    {
         if(!_SEEPR15OSN)
        {
            (updateIntegerToEEPROM(28, 0, 0x0, (_count1_Value)));
            _SEEPR15OSN=1;
        }
    }
    else
    {
         if(_SEEPR15OSN)
        {
            _SEEPR15OSN=0;
        }
    }
    if(_RTCAlO13)
    {
         if(!_SEEPR16OSN)
        {
            (updateIntegerToEEPROM(30, 0, 0x0, (_count4_Value)));
            _SEEPR16OSN=1;
        }
    }
    else
    {
         if(_SEEPR16OSN)
        {
            _SEEPR16OSN=0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO7 = 1;
        if (_RTC1.day != 31) 
        {
             _RTCAlO7 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO7 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO7 = 0;
        }
        if (_RTC1.month != 8) 
        {
             _RTCAlO7 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO7 = 0;
        }
    }
     else 
    {
        _RTCAlO7 = 0;
    }
    if(_RTCAlO7)
    {
         if(!_SEEPR17OSN)
        {
            (updateIntegerToEEPROM(32, 0, 0x0, (_count1_Value)));
            _SEEPR17OSN=1;
        }
    }
    else
    {
         if(_SEEPR17OSN)
        {
            _SEEPR17OSN=0;
        }
    }
    if(_RTCAlO7)
    {
         if(!_SEEPR18OSN)
        {
            (updateIntegerToEEPROM(34, 0, 0x0, (_count4_Value)));
            _SEEPR18OSN=1;
        }
    }
    else
    {
         if(_SEEPR18OSN)
        {
            _SEEPR18OSN=0;
        }
    }
    if (_Terminal_88442942) 
    {
        _dispTempLength1 = ((((String("AUG ")) + ((String((readIntegerFromEEPROM(32, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(34, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp12oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp12oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("AUG ")) + ((String((readIntegerFromEEPROM(32, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(34, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp12oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp12oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO8 = 1;
        if (_RTC1.day != 30) 
        {
             _RTCAlO8 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO8 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO8 = 0;
        }
        if (_RTC1.month != 9) 
        {
             _RTCAlO8 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO8 = 0;
        }
    }
     else 
    {
        _RTCAlO8 = 0;
    }
    if(_RTCAlO8)
    {
         if(!_SEEPR19OSN)
        {
            (updateIntegerToEEPROM(36, 0, 0x0, (_count1_Value)));
            _SEEPR19OSN=1;
        }
    }
    else
    {
         if(_SEEPR19OSN)
        {
            _SEEPR19OSN=0;
        }
    }
    if(_RTCAlO8)
    {
         if(!_SEEPR20OSN)
        {
            (updateIntegerToEEPROM(38, 0, 0x0, (_count4_Value)));
            _SEEPR20OSN=1;
        }
    }
    else
    {
         if(_SEEPR20OSN)
        {
            _SEEPR20OSN=0;
        }
    }
    if (_Terminal_90107467) 
    {
        _dispTempLength1 = ((((String("SEP ")) + ((String((readIntegerFromEEPROM(36, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(38, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp13oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp13oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("SEP ")) + ((String((readIntegerFromEEPROM(36, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(38, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp13oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp13oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO9 = 1;
        if (_RTC1.day != 31) 
        {
             _RTCAlO9 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO9 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO9 = 0;
        }
        if (_RTC1.month != 10) 
        {
             _RTCAlO9 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO9 = 0;
        }
    }
     else 
    {
        _RTCAlO9 = 0;
    }
    if(_RTCAlO9)
    {
         if(!_SEEPR21OSN)
        {
            (updateIntegerToEEPROM(40, 0, 0x0, (_count1_Value)));
            _SEEPR21OSN=1;
        }
    }
    else
    {
         if(_SEEPR21OSN)
        {
            _SEEPR21OSN=0;
        }
    }
    if(_RTCAlO9)
    {
         if(!_SEEPR22OSN)
        {
            (updateIntegerToEEPROM(42, 0, 0x0, (_count4_Value)));
            _SEEPR22OSN=1;
        }
    }
    else
    {
         if(_SEEPR22OSN)
        {
            _SEEPR22OSN=0;
        }
    }
    if (_Terminal_43065480) 
    {
        _dispTempLength1 = ((((String("OCT ")) + ((String((readIntegerFromEEPROM(40, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(42, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp14oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp14oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("OCT ")) + ((String((readIntegerFromEEPROM(40, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(42, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp14oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp14oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO10 = 1;
        if (_RTC1.day != 30) 
        {
             _RTCAlO10 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO10 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO10 = 0;
        }
        if (_RTC1.month != 11) 
        {
             _RTCAlO10 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO10 = 0;
        }
    }
     else 
    {
        _RTCAlO10 = 0;
    }
    if(_RTCAlO10)
    {
         if(!_SEEPR23OSN)
        {
            (updateIntegerToEEPROM(44, 0, 0x0, (_count1_Value)));
            _SEEPR23OSN=1;
        }
    }
    else
    {
         if(_SEEPR23OSN)
        {
            _SEEPR23OSN=0;
        }
    }
    if(_RTCAlO10)
    {
         if(!_SEEPR24OSN)
        {
            (updateIntegerToEEPROM(46, 0, 0x0, (_count4_Value)));
            _SEEPR24OSN=1;
        }
    }
    else
    {
         if(_SEEPR24OSN)
        {
            _SEEPR24OSN=0;
        }
    }
    if (_Terminal_44730005) 
    {
        _dispTempLength1 = ((((String("NOV ")) + ((String((readIntegerFromEEPROM(44, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(46, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp15oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp15oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("NOV ")) + ((String((readIntegerFromEEPROM(44, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(46, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp15oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp15oldLength = 0;
        }
    }
    if (1)
    {
        get3231Date(0x68, &_RTC1);
        _RTCAlO11 = 1;
        if (_RTC1.day != 31) 
        {
             _RTCAlO11 = 0;
        }
        if (_RTC1.Hours != 23) 
        {
             _RTCAlO11 = 0;
        }
        if (_RTC1.minutes != 59) 
        {
             _RTCAlO11 = 0;
        }
        if (_RTC1.month != 12) 
        {
             _RTCAlO11 = 0;
        }
        if (_RTC1.seconds != 59) 
        {
             _RTCAlO11 = 0;
        }
    }
     else 
    {
        _RTCAlO11 = 0;
    }
    if(_RTCAlO11)
    {
         if(!_SEEPR25OSN)
        {
            (updateIntegerToEEPROM(48, 0, 0x0, (_count1_Value)));
            _SEEPR25OSN=1;
        }
    }
    else
    {
         if(_SEEPR25OSN)
        {
            _SEEPR25OSN=0;
        }
    }
    if(_RTCAlO11)
    {
         if(!_SEEPR26OSN)
        {
            (updateIntegerToEEPROM(50, 0, 0x0, (_count4_Value)));
            _SEEPR26OSN=1;
        }
    }
    else
    {
         if(_SEEPR26OSN)
        {
            _SEEPR26OSN=0;
        }
    }
    if (_Terminal_46394530) 
    {
        _dispTempLength1 = ((((String("DEC")) + ((String((readIntegerFromEEPROM(48, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(50, 0, 0x0))))) + (String("m3"))))).length();
        if (_disp16oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp16oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 0);
        _lcd1.print((((String("DEC")) + ((String((readIntegerFromEEPROM(48, 0, 0x0)), DEC))) + (String(".")) + ((_convertNumbeToTime((readIntegerFromEEPROM(50, 0, 0x0))))) + (String("m3")))));
    }
     else 
    {
        if (_disp16oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp16oldLength = 0;
        }
    }
    //Плата:4
//Наименование:МЕНЮ
    bool  _tmp2 = !(_bounseInputD1O);
    if (_tmp2)  
    {
         if (! _trgt2I) _trgt2 = ! _trgt2;
    }
    _trgt2I = _tmp2;
    if (_trgt2) 
    {
        _tempVariable_bool  =  1;
        if (! _MenuBlock_248902600_OEIS) 
        {
            _MenuBlock_248902600_OEIS = 1;
        }
        _tempVariable_int = pgm_read_byte(&_menuParametrsArray[((_MainMenus[0].currentItem).startInArrayIndex)+10]);
        _MenuBlock_248902600_MNO = _readStringFromProgmem ((char*)pgm_read_word(&(_flprogMenuStringsArray[_tempVariable_int - 1])));
        _MenuBlock_248902600_VNO = _menuOutputValueString (0);
    }
     else 
    {
        _tempVariable_bool  =  0;
        if (_MenuBlock_248902600_OEIS)
        {
            _MenuBlock_248902600_OEIS = 0;
        }
        _MenuBlock_248902600_MNO = "";
        _MenuBlock_248902600_VNO = "";
    }
    if(!(_bounseInputD2O)) 
    {
         if (! _MenuBlock_248902600_OMUIS) 
        {
            _MenuBlock_248902600_OMUIS = 1;
            if(_tempVariable_bool)
            {
                  _menuUpEvents(0);
            }
        }
    }
     else 
    {
        _MenuBlock_248902600_OMUIS = 0;
    }
    if(!(_bounseInputD3O)) 
    {
         if (! _MenuBlock_248902600_OMDIS) 
        {
            _MenuBlock_248902600_OMDIS = 1;
            if(_tempVariable_bool)
            {
                   _menuDownEvents(0);
            }
        }
    }
     else 
    {
        _MenuBlock_248902600_OMDIS = 0;
    }
    if(!(_bounseInputD6O)) 
    {
         if (! _MenuBlock_248902600_OVUIS) 
        {
            _MenuBlock_248902600_OVUIS = 1;
            if(_tempVariable_bool)
            {
                  _valueUpEvents(0);
            }
        }
    }
     else 
    {
        _MenuBlock_248902600_OVUIS = 0;
    }
    if(!(_bounseInputD5O)) 
    {
         if (! _MenuBlock_248902600_OVDIS) 
        {
            _MenuBlock_248902600_OVDIS = 1;
            if(_tempVariable_bool)
            {
                  _valueDownEvents(0);
            }
        }
    }
     else 
    {
        _MenuBlock_248902600_OVDIS = 0;
    }
    if (_gtv2) 
    {
        _dispTempLength1 = ((_MenuBlock_248902600_VNO)).length();
        if (_disp3oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp3oldLength = _dispTempLength1;
        _lcd1.setCursor(5, 1);
        _lcd1.print((_MenuBlock_248902600_VNO));
    }
     else 
    {
        if (_disp3oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp3oldLength = 0;
        }
    }
    if (_gtv2) 
    {
        _dispTempLength1 = ((_MenuBlock_248902600_MNO)).length();
        if (_disp2oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp2oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 1);
        _lcd1.print((_MenuBlock_248902600_MNO));
    }
     else 
    {
        if (_disp2oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp2oldLength = 0;
        }
    }
    _gtv2 = _trgt2;
    if (_gtv2)
    {
        if (!(_RTCST_Ost2))
        {
            set3231Date(0x68, &_RTC1, ((_menuValueArray_int[1])), ((_menuValueArray_int[3])), ((_menuValueArray_int[4])), ((_menuValueArray_int[5])), ((_menuValueArray_int[0])), ((_menuValueArray_int[2])), -1);
            get3231Date(0x68, &_RTC1);
            _RTCST_Ost2 = 1;
        }
    }
    else
    {
         _RTCST_Ost2 = 0;
    }
    get3231Date(0x68, &_RTC1);
    _RTC1_GetTime2_StrOut = (_convertRealTimeClockNumberToString(_RTC1.day))+
    String("-")+
    (_convertRealTimeClockNumberToString(_RTC1.month))+
    String("-")+
    (String("20") +(_convertRealTimeClockNumberToString (_RTC1.year)))+
    String(", ")+
    (_convertRealTimeClockNumberToString(_RTC1.Hours))+
    String(":")+
    (_convertRealTimeClockNumberToString(_RTC1.minutes))+
    String(":")+
    (_convertRealTimeClockNumberToString(_RTC1.seconds));
    if (!(_gtv2)) 
    {
        _dispTempLength1 = ((_RTC1_GetTime2_StrOut)).length();
        if (_disp1oldLength > _dispTempLength1) 
        {
            _isNeedClearDisp1 = 1;
        }
        _disp1oldLength = _dispTempLength1;
        _lcd1.setCursor(0, 1);
        _lcd1.print((_RTC1_GetTime2_StrOut));
    }
     else 
    {
        if (_disp1oldLength > 0) 
        {
            _isNeedClearDisp1 = 1;
            _disp1oldLength = 0;
        }
    }
    //Плата:5
//Наименование:Просмотр по месяцам
    if (((!(_bounseInputD13O)) || (_gtv4)))
    {
        _count2_Value = 0;
    }
     else 
    {
        if (!(_bounseInputD16O))
        {
            if (! _count2I) 
            {
                _count2I = 1;
                _count2_Value = _count2_Value + 1;
            }
        }
         else 
        {
            _count2I = 0;
        }
        if (!(_bounseInputD17O))
        {
            if (! _count2_SCST) 
            {
                _count2_SCST = 1;
                _count2_Value = _count2_Value - 1;
            }
        }
         else 
        {
            _count2_SCST = 0;
        }
    }
    _count2MaxLO = _count2_Value >= 13;
    _Terminal_46394530 = (_count2_Value) == (12);
    _Terminal_44730005 = (_count2_Value) == (11);
    _Terminal_43065480 = (_count2_Value) == (10);
    _Terminal_90107467 = (_count2_Value) == (9);
    _Terminal_88442942 = (_count2_Value) == (8);
    _Terminal_86778417 = (_count2_Value) == (7);
    _Terminal_75126742 = (_count2_Value) == (0);
    _Terminal_85113892 = (_count2_Value) == (6);
    _Terminal_83449367 = (_count2_Value) == (5);
    _Terminal_81784842 = (_count2_Value) == (4);
    _Terminal_80120317 = (_count2_Value) == (3);
    _Terminal_78455792 = (_count2_Value) == (2);
    _Terminal_76791267 = (_count2_Value) == (1);
    _gtv4 = _count2MaxLO;
}
bool _isTimer(unsigned long startTime, unsigned long period)
{
    unsigned long currentTime;
    currentTime = millis();
    if (currentTime>= startTime) 
    {
        return (currentTime>=(startTime + period));
    }
     else 
    {
        return (currentTime >=(4294967295-startTime+period));
    }
}
String _readStringFromProgmem (char *string)
{
    String result = String("");
    while (pgm_read_byte(string)!='\0')
    {
        result=result+ char(pgm_read_byte(string));
        	string++;
        	
    }
    return result;
}
void _menuUpEvents (int menuIndex)
{
    int tempIndex = pgm_read_byte(&_menuParametrsArray[((_MainMenus[menuIndex]).currentItem).startInArrayIndex]);
    int parIndex = pgm_read_byte(&_menuParametrsArray[ (((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+5]);
    int parentStartIndex;
    int parentStopIndex;
    if (parIndex == 0) 
    {
        parentStartIndex = (_MainMenus[menuIndex]).startIndex;
        parentStopIndex =(_MainMenus[menuIndex]).stopIndex;
    }
    else 
    {
        parentStartIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex - 1]).startInArrayIndex)+3]);
        parentStopIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex-1]).startInArrayIndex)+4]);
    }
    if (tempIndex == parentStartIndex) 
    {
        if((_MainMenus[menuIndex]).isSwitchMenuAroundRing) 
        {
            (_MainMenus[menuIndex]).currentItem = _MenuItems[parentStopIndex -1];
            return;
        }
         else
        {
            return;
        }
    }
    (_MainMenus[menuIndex]).currentItem = _MenuItems[tempIndex - 2];
    return;
}
void _menuDownEvents (int menuIndex)
{
    int tempIndex = pgm_read_byte(&_menuParametrsArray[((_MainMenus[menuIndex]).currentItem).startInArrayIndex]);
    int parIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+5]);
    int parentStartIndex;
    int parentStopIndex;
    if (parIndex == 0) 
    {
        parentStartIndex = (_MainMenus[menuIndex]).startIndex;
        parentStopIndex =(_MainMenus[menuIndex]).stopIndex;
    }
    else 
    {
        parentStartIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex-1]).startInArrayIndex)+3]);
        parentStopIndex = pgm_read_byte(&_menuParametrsArray[((_MenuItems[parIndex-1]).startInArrayIndex)+4]);
    }
    if (tempIndex == parentStopIndex) 
    {
        if((_MainMenus[menuIndex]).isSwitchMenuAroundRing) 
        {
            (_MainMenus[menuIndex]).currentItem = _MenuItems[parentStartIndex -1];
            return;
        }
         else
        {
            return;
        }
    }
    (_MainMenus[menuIndex]).currentItem = _MenuItems[tempIndex];
    return;
}
void _valueUpEvents (int menuIndex)
{
    int valIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+2]);
    int itemType = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+1]);
    int indexMax = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+6]);
    int indexStep = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+8]);
    if (itemType == 4) 
    {
        if (! indexMax == 0) 
        {
             if (! (int(pgm_read_word(&_menuConstantValuesArray_int[indexMax -1])) > int(_menuValueArray_int[valIndex -1]))) 
            {
                return;
            }
        }
        _menuValueArray_int[valIndex -1] = _menuValueArray_int[valIndex -1] + (pgm_read_word(&_menuConstantValuesArray_int[indexStep -1]));
    }
}
void _valueDownEvents (int menuIndex)
{
    int valIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+2]);
    int itemType = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+1]);
    int indexMin = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+7]);
    int indexStep = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+8]);
    if (itemType == 4) 
    {
        if (! indexMin == 0) 
        {
             if (! ((int(pgm_read_word(&_menuConstantValuesArray_int[indexMin - 1]))) < int(_menuValueArray_int[valIndex - 1]))) 
            {
                return;
            }
        }
        _menuValueArray_int[valIndex - 1] = _menuValueArray_int[valIndex - 1] - (pgm_read_word(&_menuConstantValuesArray_int[indexStep - 1]));
    }
}
String _menuOutputValueString (int menuIndex)
{
    int itemType = pgm_read_byte(&_menuParametrsArray[ (((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+1]);
    int valIndex = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+2]);
    int indexMin = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+7]);
    int indexMax = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+6]);
    if(valIndex == 0)
    {
         return "";
    }
    int convFormat = pgm_read_byte(&_menuParametrsArray[(((_MainMenus[menuIndex]).currentItem).startInArrayIndex)+9]);
    if(itemType == 4) 
    {
         return _convertNamber(itemType, convFormat, valIndex, indexMax, indexMin);
    }
    return "";
}
String _convertNamber(int itemType, int convFormat, int valIndex, int indexMax, int indexMin)
{
    if (itemType== 4) 
    {
        if (convFormat == 4) 
        {
             return String((_menuValueArray_int[valIndex - 1 ]),DEC);
        }
        if (convFormat == 5) 
        {
             return String((_menuValueArray_int[valIndex - 1]),HEX);
        }
        if (convFormat == 6) 
        {
             return String((_menuValueArray_int[valIndex -1]),BIN);
        }
    }
}
byte readByteFromEEPROM(int addres, byte bitAddres, byte chipAddres)
{
    return EEPROM.read(addres);
}
void updateByteToEEPROM(int addres, byte bitAddres, byte chipAddres, byte value)
{
    return EEPROM.update(addres, value);
}
int readIntegerFromEEPROM(int addres, byte bitAddres, byte chipAddres)
{
    byte hight = readByteFromEEPROM(addres,  bitAddres,  chipAddres);
    byte low = readByteFromEEPROM((addres+1),  bitAddres,  chipAddres);
    return  word(hight, low);
}
void updateIntegerToEEPROM(int addres, byte bitAddres, byte chipAddres, int value)
{
    updateByteToEEPROM(addres,  bitAddres,  chipAddres, highByte(value));
    updateByteToEEPROM((addres+1),  bitAddres,  chipAddres, lowByte(value));
}
byte decToBcd(byte val)
{
    return ((val/10*16) + (val%10));
}
void set3231Date(int addres, struct _I2CRealRimeClockTime *timeStruct, int sec, int  minut, int hou, int dat, int mo, int ye, int daW)
{
    byte temp;
    Wire.beginTransmission(addres);
    Wire.write(0x00);
    if (sec < 0) 
    {
        temp = timeStruct -> seconds;
    }
     else 
    {
        temp = sec;
    }
    Wire.write(decToBcd(temp));
    if (minut < 0) 
    {
        temp = timeStruct -> minutes;
    }
     else 
    {
        temp = minut;
    }
    Wire.write(decToBcd(temp));
    if (hou < 0) 
    {
        temp = timeStruct -> Hours;
    }
     else 
    {
        temp = hou;
    }
    Wire.write(decToBcd(temp));
    if (daW < 0) 
    {
        temp = timeStruct -> weekday;
    }
     else 
    {
        temp = daW;
    }
    Wire.write(decToBcd(temp));
    if (dat < 0) 
    {
        temp = timeStruct -> day;
    }
     else 
    {
        temp = dat;
    }
    Wire.write(decToBcd(temp));
    if (mo < 0) 
    {
        temp = timeStruct -> month;
    }
     else 
    {
        temp = mo;
    }
    Wire.write(decToBcd(temp));
    if (ye < 0) 
    {
        temp = timeStruct -> year;
    }
     else 
    {
        temp = ye;
    }
    Wire.write(decToBcd(temp));
    Wire.endTransmission();
    timeStruct ->startTime = millis() - 1000;
}
void get3231Date(int addres, struct _I2CRealRimeClockTime *timeStruct)
{
    if (!(_isTimer ((timeStruct ->startTime), 250))) 
    {
        return;
    }
    Wire.beginTransmission(addres);
    Wire.write(0x00);
    Wire.endTransmission();
    Wire.requestFrom(addres, 7);
    if (Wire.available()) 
    {
        byte  seconds = Wire.read();
        byte minutes = Wire.read();
        byte hours   = Wire.read();
        byte day     = Wire.read();
        byte date    = Wire.read();
        byte month   = Wire.read();
        byte year    = Wire.read();
        timeStruct -> seconds = (((seconds & B11110000) >> 4) * 10 + (seconds & B00001111));
        timeStruct -> minutes = (((minutes & B11110000) >> 4) * 10 + (minutes & B00001111));
        timeStruct -> Hours = (((hours & B00110000) >> 4) * 10 + (hours & B00001111));
        timeStruct -> weekday = (day & B00000111);
        timeStruct -> day    = (((date & B00110000) >> 4) * 10 + (date & B00001111));
        timeStruct -> month   = (((month & B00010000) >> 4) * 10 + (month & B00001111));
        timeStruct -> year    = (((year & B11110000) >> 4) * 10 + (year & B00001111));
    }
     timeStruct ->startTime = millis();
}
String _convertRealTimeClockNumberToString(byte value)
{
    if (value > 9) 
    {
        return String(value, DEC);
    }
    return (String("0") + String(value, DEC));
}
String _convertNumbeToTime(long value)
{
    if (value > 9) 
    {
        return String(value, DEC);
    }
    return (String("0") + String(value, DEC));
}
